/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Analog;
import DE.siemens.ad.logo.model.AnalogOrBlockReference;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.IntegerOrBlockReference;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.model.Minutes;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.model.Timer;
import DE.siemens.ad.logo.util.AnalogValueProperties;
import DE.siemens.ad.logo.util.DoubleValueProperties;
import DE.siemens.ad.logo.util.IntValueProperties;
import DE.siemens.ad.logo.util.TimeValueProperties;
import DE.siemens.ad.logo.util.Util;
import java.io.IOException;

public class PIDParameter
extends Analog {
    static final long serialVersionUID = 0L;
    private int serializedDataVersion = 2;
    private transient double fAnalogValue;
    private char fDirection = (char)43;
    private AnalogOrBlockReference fSetpoint;
    private DoubleValueProperties fLoopGain;
    private Timer fIntegralTimer;
    private Timer fSampleTimer;
    private int fParametersetName;
    private IntegerOrBlockReference fManualOutput;
    private transient double fT0 = 0.0;
    private transient double fMx = 0.0;
    private static final int NO_AUTO_HISTORY = 0;
    private transient IntValueProperties fAnalogValueProperties;

    public PIDParameter() {
    }

    public PIDParameter(Block block) {
        super(block);
        this.setRemanenceAvailable(true);
        this.getRemanenceObject().setRemanence(true);
        if (this.fParametersetName == 0) {
            this.getIntegralTimer().getParamTime().setTime(0, 30);
            this.getLoopGainProperties().setCurrentValue(0.5);
        }
    }

    public double calculateAnalogValue(boolean autoManual, boolean reset, double pv) {
        this.fXInput = pv;
        boolean AUTO_HISTORY = true;
        double SAMPLE_TIME = 500.0;
        double SAMPLE_TIME_IN_MINUTES = 0.008333333333333333;
        this.fAmplifiedX = this.fMeasurement.getAmplifiedValue((int)pv);
        pv = this.fAmplifiedX;
        if (reset) {
            this.fAnalogValue = 0.0;
            this.fState = 0;
        } else if (autoManual) {
            if (this.fState == 0) {
                this.fMx = this.fAnalogValue / 1000.0;
                this.fState = 1;
                this.fT0 = (double)this.fInterpreter.getCurrentSimulationTimerTime() - 500.0;
            }
            if ((double)this.fInterpreter.getCurrentSimulationTimerTime() - this.fT0 >= 500.0) {
                double fIntegralCoefficient;
                double dirFactor;
                this.fT0 = this.fInterpreter.getCurrentSimulationTimerTime();
                double d = dirFactor = this.getDirection().charValue() == '-' ? -1.0 : 1.0;
                if (this.getIntegralTimer().getParamTime().getMilliseconds() == 5999000L) {
                    fIntegralCoefficient = 0.0;
                } else {
                    double ti = (double)this.getIntegralTimer().getParamTime().getMilliseconds() / 1000.0 / 60.0;
                    fIntegralCoefficient = 0.008333333333333333 / ti;
                    if (Double.isInfinite(fIntegralCoefficient) || Double.isNaN(fIntegralCoefficient)) {
                        fIntegralCoefficient = 0.0;
                    }
                    if (this.getLoopGainProperties().getCurrentValue() != 0.0) {
                        fIntegralCoefficient *= this.getLoopGainProperties().getCurrentValue();
                    }
                    fIntegralCoefficient *= dirFactor;
                }
                pv = (double)(this.fAmplifiedX - this.getMinPV()) / (double)(this.getMaxPV() - this.getMinPV());
                double sp = (double)(this.getSetpoint().getValue() - this.getMinPV()) / (double)(this.getMaxPV() - this.getMinPV());
                double mp = this.getLoopGainProperties().getCurrentValue() * dirFactor * (sp - pv);
                double mi = fIntegralCoefficient * (sp - pv) + this.fMx;
                double tempAQ = mp + mi;
                if (tempAQ > 1.0) {
                    tempAQ = 1.0;
                    mi = 1.0 - mp;
                } else if (tempAQ < 0.0) {
                    tempAQ = 0.0;
                    mi = -mp;
                }
                if (this.getIntegralTimer().getParamTime().getMilliseconds() != 5999000L) {
                    this.fMx = mi;
                    if (mi > 1.0) {
                        this.fMx = 1.0;
                    } else if (mi < 0.0) {
                        this.fMx = 0.0;
                    }
                }
                this.fAnalogValue = (int)Math.round(tempAQ * 1000.0);
            }
        } else {
            this.fAnalogValue = this.getManualOutput().getValue();
            if (this.fAnalogValue > 1000.0) {
                this.fAnalogValue = 1000.0;
            } else if (this.fAnalogValue < 0.0) {
                this.fAnalogValue = 0.0;
            }
            this.fState = 0;
        }
        this.fCurrentParameterText = this.calculateCurrentParameterText();
        return this.fAnalogValue;
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        super.init(interpreter, forceReset);
        this.getIntegralTimer().init(interpreter);
        if (forceReset) {
            this.fState = 0;
            this.fAnalogValue = 0.0;
        }
    }

    public String getParameterText() {
        StringBuffer buffer = new StringBuffer(super.getParameterText());
        if (buffer.length() > 0) {
            buffer.append("\n");
        }
        buffer.append("Gain  =").append(this.getGainString()).append(this.getProtectionSign()).append("\nOffset=").append(this.getOffset()).append("\nSP=").append(this.getSetpoint().getParameterText()).append("\nMq=").append(this.getManualOutput().getParameterText()).append("\nKC=").append(this.getLoopGainProperties().getCurrentValue()).append("\nTI=").append(this.getIntegralTime().getCurrentValue()).append("\nDir=").append(this.getDirection()).append("\nPoint =").append(this.getDecimalPlace());
        return buffer.toString();
    }

    public String calculateCurrentParameterText() {
        String value = Double.toString(this.fAnalogValue);
        value = Util.addTrailingSpaces(value, 8);
        this.fireParameterUpdateEvent();
        return value;
    }

    public IntValueProperties getAmplifiedAQ() {
        if (this.fAnalogValueProperties == null) {
            this.fAnalogValueProperties = new IntValueProperties(MIN_TRIGGER, MAX_TRIGGER, 1, (int)Math.round(this.fXInput), "error.dialog.invalidValue", "Invalid Value");
        }
        this.fAnalogValueProperties.setCurrentValue((int)this.fAnalogValue);
        return this.fAnalogValueProperties;
    }

    public Timer getIntegralTimer() {
        if (this.fIntegralTimer == null) {
            Timer timer = this.getInitializedTimer("dialog.parameter.pid.integral");
            this.setIntegralTimer(timer);
        }
        if (this.fIntegralTimer.getAvailableTimeUnitObjects().length > 1) {
            this.fIntegralTimer.setAvailableTimeUnits(new TimeUnit[]{new Minutes()});
        }
        return this.fIntegralTimer;
    }

    private Timer getInitializedTimer(String timerNameKey) {
        Minutes minutes = new Minutes();
        Timer timer = new Timer(minutes);
        timer.setNameKey(timerNameKey);
        return timer;
    }

    public void setIntegralTimer(Timer timer) {
        this.fIntegralTimer = timer;
    }

    public TimeValueProperties getIntegralTime() {
        return this.getIntegralTimer().getParamTimeProperties();
    }

    public void setIntegralTime(TimeValueProperties integralTime) {
        this.getIntegralTimer().setParamTimeProperties(integralTime);
    }

    public DoubleValueProperties getLoopGainProperties() {
        if (this.fLoopGain == null) {
            this.fLoopGain = new DoubleValueProperties(0.0, 99.99, 0.01, 1.0, 2, "error.pid.gain", "Wrong value in loop gain.");
        }
        return this.fLoopGain;
    }

    public void setLoopGainProperties(DoubleValueProperties loopGain) {
        this.fLoopGain.setCurrentValue(loopGain.getCurrentValue());
    }

    public AnalogOrBlockReference getSetpoint() {
        if (this.fSetpoint == null) {
            this.fSetpoint = new AnalogOrBlockReference(this);
            this.fSetpoint.setIntValueProperties(new AnalogValueProperties(-10000, 20000, 1, 0, 0, "error.pid.setpoint", "Error input Setpoint"));
        }
        this.fSetpoint.setDecimalPlace(this.getDecimalPlace());
        return this.fSetpoint;
    }

    public void setSetpoint(IntegerOrBlockReference setpoint) {
        this.fSetpoint.setValue(setpoint);
    }

    public void setSetpoint(AnalogOrBlockReference setpoint) {
        this.fSetpoint.setValue(setpoint);
    }

    public Character getDirection() {
        return Character.valueOf(this.fDirection);
    }

    public void setDirection(Character direction) {
        this.fDirection = direction.charValue();
    }

    public void setParameterset(int paramsetIndex) {
        this.fParametersetName = paramsetIndex;
    }

    public int getParameterset() {
        return this.fParametersetName;
    }

    public IntegerOrBlockReference getManualOutput() {
        if (this.fManualOutput == null) {
            this.fManualOutput = new IntegerOrBlockReference(this);
            this.fManualOutput.setIntValueProperties(new IntValueProperties(0, 1000, 1, 0, "error.pid.mq", "Error input Manual Output"));
        }
        return this.fManualOutput;
    }

    public void setManualOutput(IntegerOrBlockReference manualOutput) {
        this.fManualOutput.setValue(manualOutput);
    }

    public int getMaxPV() {
        return (int)Math.round(this.getMeasurement().getMaxMeasuredValue());
    }

    public int getMinPV() {
        return (int)Math.round(this.getMeasurement().getMinMeasuredValue());
    }

    public AnalogValueProperties getMaxPVProperties() {
        int currentValue = (int)Math.round(this.getMeasurement().getMaxMeasuredValue());
        return new AnalogValueProperties(-10000, 20000, 1, currentValue, this.getDecimalPlace(), true, "error.minPV", "wrong value for minPV");
    }

    public AnalogValueProperties getMinPVProperties() {
        int currentValue = (int)Math.round(this.getMeasurement().getMinMeasuredValue());
        return new AnalogValueProperties(-10000, 20000, 1, currentValue, this.getDecimalPlace(), true, "error.minPV", "wrong value for minPV");
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeString(String.valueOf(this.fDirection));
        dw.writeStorable(this.fIntegralTimer);
        dw.writeStorable(this.fLoopGain);
        dw.writeStorable(this.fManualOutput);
        dw.writeInt(this.fParametersetName);
        dw.writeStorable(this.fSampleTimer);
        dw.writeStorable(this.fSetpoint);
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fDirection = dr.readString().charAt(0);
        this.fIntegralTimer = (Timer)dr.readStorable();
        this.fLoopGain = (DoubleValueProperties)dr.readStorable();
        this.fManualOutput = (IntegerOrBlockReference)dr.readStorable();
        this.fParametersetName = dr.readInt();
        this.fSampleTimer = (Timer)dr.readStorable();
        this.fSetpoint = (AnalogOrBlockReference)dr.readStorable();
    }
}

